#Requires AutoHotkey v2.0
#SingleInstance Force

^,::                 ; Ctrl+, で連打検知
{
HandleDoubleTap()
}

^+/::
{
HandleOnce()         ; Ctrl+Shift+/
}

HandleDoubleTap() {
    static last := 0
    now := A_TickCount

    if (now - last < 400) {
        last := 0
        DoSearchMenu()
    } else {
        last := now
    }
}

HandleOnce() {
    DoSearchMenu()
}

DoSearchMenu() {
    old := ClipboardAll()
    A_Clipboard := ""
    Send "^c"
    if ClipWait(0.6) {
        q := Trim(A_Clipboard)
        if (q != "")
            ShowSearchMenu(q)
    }
    A_Clipboard := old
}

ShowSearchMenu(q) {
    m := Menu()

    m.Add("北辞郎", (*) => OpenUrl("https://www.ctrans.org/search.php?word=" . UrlEncode(q)))
    m.Add("Google", (*) => OpenUrl("https://www.google.com/search?q=" . UrlEncode(q)))
    m.Add("Wikipedia", (*) => OpenUrl("https://ja.wikipedia.org/wiki/Special:Search?search=" . UrlEncode(q)))
    m.Add("英辞郎", (*) => OpenUrl("https://eow.alc.co.jp/search?q=" . UrlEncode(q)))
    m.Add("コトバンク", (*) => OpenUrl("https://kotobank.jp/search?t=all&q=" . UrlEncode(q)))
    m.Add("百度", (*) => OpenUrl("https://www.baidu.com/s?wd=" . UrlEncode(q)))
    m.Add() ; separator

    m.Add("Kagi（中日）", (*) => OpenUrl("https://translate.kagi.com/?from=zh_cn&to=ja&text=" . UrlEncode(q)))
    m.Add("DeepL（中日）", (*) => OpenUrl("https://www.deepl.com/translator#zh/ja/" . UrlEncode(q)))

    ; 表示位置：キャレット優先 → マウス fallback
    x := "", y := ""
    if !CaretGetPos(&x, &y) {
        MouseGetPos &x, &y
    }
    m.Show(x, y)
}

OpenUrl(url) {
    Run(url)
}

UrlEncode(str) {
    bufSize := StrPut(str, "UTF-8")
    buf := Buffer(bufSize)
    StrPut(str, buf, "UTF-8")

    out := ""
    Loop bufSize - 1 {
        b := NumGet(buf, A_Index - 1, "UChar")
        if ( (b >= 0x30 && b <= 0x39)
          || (b >= 0x41 && b <= 0x5A)
          || (b >= 0x61 && b <= 0x7A)
          || b = 0x2D || b = 0x5F
          || b = 0x2E || b = 0x7E ) {
            out .= Chr(b)
        } else {
            out .= "%" . Format("{:02X}", b)
        }
    }
    return out
}
